/*
  Arduino API main include
  Copyright (c) 2016 Arduino LLC. All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef ARDUINO_API_H
#define ARDUINO_API_H

// version 1.0.0
#define ARDUINO_API_VERSION 10000

#include "Binary.h"

#ifdef __cplusplus
#include "Client.h"
#include "HardwareI2C.h"
#include "HardwareSerial.h"
#include "IPAddress.h"
#include "PluggableUSB.h"
#include "Print.h"
#include "Printable.h"
#include "Server.h"
#include "Stream.h"
#include "String.h"
#include "USBAPI.h"
#include "Udp.h"
#include "WCharacter.h"
#endif

/* Standard C library includes */
#include <math.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

// Misc Arduino core functions
#include "Common.h"

#endif
