/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.url;

import java.net.MalformedURLException;

public class Uri {
    protected String uri;
    protected String scheme;
    protected String host = null;
    protected int port = -1;
    protected boolean hasAuthority;
    protected String path;
    protected String query = null;

    public Uri(String string) throws MalformedURLException {
        this.init(string);
    }

    protected Uri() {
    }

    protected void init(String string) throws MalformedURLException {
        this.uri = string;
        this.parse(string);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        return this.uri;
    }

    private void parse(String string) throws MalformedURLException {
        int n;
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            throw new MalformedURLException("Invalid URI: " + string);
        }
        this.scheme = string.substring(0, n2);
        this.hasAuthority = string.startsWith("//", ++n2);
        if (this.hasAuthority) {
            n = string.indexOf(47, n2 += 2);
            if (n < 0) {
                n = string.length();
            }
            if (string.startsWith("[", n2)) {
                int n3 = string.indexOf(93, n2 + 1);
                if (n3 < 0 || n3 > n) {
                    throw new MalformedURLException("Invalid URI: " + string);
                }
                this.host = string.substring(n2, n3 + 1);
                n2 = n3 + 1;
            } else {
                int n4;
                int n5 = string.indexOf(58, n2);
                int n6 = n4 = n5 < 0 || n5 > n ? n : n5;
                if (n2 < n4) {
                    this.host = string.substring(n2, n4);
                }
                n2 = n4;
            }
            if (n2 + 1 < n && string.startsWith(":", n2)) {
                this.port = Integer.parseInt(string.substring(++n2, n));
            }
            n2 = n;
        }
        if ((n = string.indexOf(63, n2)) < 0) {
            this.path = string.substring(n2);
        } else {
            this.path = string.substring(n2, n);
            this.query = string.substring(n);
        }
    }
}

